#include "FilesList.h"

#include <vector>
#include <map>
#include "xmedia.h"
#include <algorithm>

using namespace std;

string FL_BaseDir;
string FL_CurrentDir;
string FL_CurrentFile;
FileItems * files = NULL;

bool SortFiles(const FileItem * left, const FileItem * right) 
{ 
	if (left->IsDir != right->IsDir) return left->IsDir;

	int res = _stricmp(left->name.c_str(),right->name.c_str());
	if (res < 0) return true;
	return false;
}

HRESULT CFilesList::OnInit(XUIMessageInit *pInitData, BOOL& bHandled)
{
	DebugMsg("CFilesList::OnInit");
	CurSel = 0;

	SetTimer(TM_FORCECHECK,150);

	return S_OK;
}

HRESULT CFilesList::OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled )
{
	if (pTimer->nId == TM_FORCECHECK)
	{
		if (CurSel < 0 || CurSel >= files->nItems)
			return S_OK;

		if (!GetItemCheck(CurSel))
			SetItemCheck(CurSel,TRUE);
	}

	return S_OK;
}
    

// Gets called every frame
HRESULT CFilesList::OnGetSourceDataText(XUIMessageGetSourceText *pGetSourceTextData, BOOL& bHandled)
{
	//DebugMsg("OnGetSourceDataText - %d",pGetSourceTextData->iData);
	// filename
	if( ( 0 == pGetSourceTextData->iData ) && ( ( pGetSourceTextData->bItemData ) ) ) {
		pGetSourceTextData->szText = 
			files->pItems[pGetSourceTextData->iItem]->wname.c_str();
		bHandled = TRUE;
	}
	// extra text
	if( ( 1 == pGetSourceTextData->iData ) && ( ( pGetSourceTextData->bItemData ) ) ) {
		pGetSourceTextData->szText = 
			files->pItems[pGetSourceTextData->iItem]->wsize.c_str();
		bHandled = TRUE;
	}
	return S_OK;
}
    
HRESULT CFilesList::OnGetItemCountAll(XUIMessageGetItemCount *pGetItemCountData, BOOL& bHandled)
{
	//DebugMsg("OnGetItemCountAll - %d items",files->nItems);
	pGetItemCountData->cItems = files->nItems;
	bHandled = TRUE;
	return S_OK;
}

HRESULT CFilesList::OnGetSourceDataImage(XUIMessageGetSourceImage *pGetSourceImageData, BOOL& bHandled)
{
	//DebugMsg("OnGetSourceDataImage - %d",pGetSourceImageData->iData);
	// icon
	if( ( 2 == pGetSourceImageData->iData ) && ( pGetSourceImageData->bItemData ) ) {
		if (files->pItems[pGetSourceImageData->iItem]->IsDir)
		{
			pGetSourceImageData->szPath = L"folder.png";
		} else {
			pGetSourceImageData->szPath = L"file.png";
		}
		bHandled = TRUE;
	}
	return S_OK;
}

HRESULT CFilesList::OnListRefresh(BOOL& bHandled )
{
	files = GetFiles();
	InsertItems( 0, 1 );
	if (files->nItems > 0)
		SetItemCheck(0,TRUE);

	CurSel = 0;
	SetCurSel(0);
	SetTopItem(0);

	if (files->nItems > 0)
	{
		FL_CurrentFile = files->pItems[CurSel]->name;

		XUIMessage xuiMsg;
		XuiMessage(&xuiMsg, XM_FILES_FILECHANGE);
		HXUIOBJ hObjParent;
		this->GetParent(&hObjParent);
		XuiSendMessage( hObjParent , &xuiMsg );

		XuiMessage(&xuiMsg, XM_FILES_DIRCHANGE);
		XuiSendMessage( hObjParent , &xuiMsg );
	}

	return( S_OK );
}

FileItems* CFilesList::GetFiles()
{
	if (files != NULL)
	{
		for (int i = 0 ; i < files->nItems ; i++)
		{
			delete files->pItems[i];
		}
		delete files;
		files = NULL;
	}

	FileItems * result = new FileItems();
	//result.pItems = new ContentItem[Content.size()];

	memset(result->pItems,0,1000);

	if (FL_BaseDir.empty())
	{
		result->nItems = 0;
		return result;
	}


	string filename = FL_BaseDir + "\\" + FL_CurrentDir + "\\";
	filename = str_replaceallA(filename,"\\\\","\\");
	filename.append("*.*");
	//DebugMsg("Finding %s",filename.c_str());
	WIN32_FIND_DATA findFileData;
	memset(&findFileData,0,sizeof(WIN32_FIND_DATA));
	HANDLE hFind = FindFirstFile(filename.c_str(), &findFileData);

	vector <FileItem *> TempItems;

	if (hFind != INVALID_HANDLE_VALUE)
	{
		do {
			string s = findFileData.cFileName;

			if (s == ".") continue;
			if (s == "..") continue;

			FileItem * item = new FileItem();
			if (findFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
				item->IsDir = true;

			item->size.HighPart = findFileData.nFileSizeHigh;
			item->size.LowPart = findFileData.nFileSizeLow;

			item->name = s;

			item->CreateWStrs();

			TempItems.push_back(item);

			//DebugMsg("File %s",s.c_str());

		} while (FindNextFile(hFind, &findFileData));
		FindClose(hFind);
	}

	sort(TempItems.begin(),TempItems.end(),SortFiles);

	int count = 0;
	vector <FileItem *>::iterator itr;
	for (itr = TempItems.begin() ; itr != TempItems.end() ; itr++)
	{
		FileItem * item = (*itr);
		result->pItems[count] = item;
		count++;
	}

	result->nItems = count;

	return result;
}

HRESULT CFilesList::OnNotifySelChanged( HXUIOBJ hObjSource, XUINotifySelChanged* pNotifySelChangedData, BOOL& bHandled )
{
	// move check
	int NewSel = GetCurSel(); 
	SetItemCheck(CurSel,FALSE);
	CurSel = NewSel;

	FL_CurrentFile = files->pItems[CurSel]->name;

	XUIMessage xuiMsg;
	XuiMessage(&xuiMsg, XM_FILES_FILECHANGE);
	HXUIOBJ hObjParent;
	this->GetParent(&hObjParent);
	XuiSendMessage( hObjParent , &xuiMsg );

	bHandled = TRUE;

    return S_OK;
}

HRESULT CFilesList::OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
{
	FileItem * item = files->pItems[CurSel];

	if (item->IsDir)
	{
		FL_CurrentDir.append("\\");
		FL_CurrentDir.append(item->name);

		DebugMsg("Changing Dir to %s",FL_CurrentDir.c_str());
		
		BOOL Temp = FALSE;
		CurSel = 0;
		SetCurSel(0);
		SetTopItem(0);
		OnListRefresh(Temp);

		XUIMessage xuiMsg;
		XuiMessage(&xuiMsg, XM_FILES_DIRCHANGE);
		HXUIOBJ hObjParent;
		this->GetParent(&hObjParent);
		XuiSendMessage( hObjParent , &xuiMsg );
	} else {
		XUIMessage xuiMsg;
		XuiMessage(&xuiMsg, XM_FILES_FILEPRESS);
		HXUIOBJ hObjParent;
		this->GetParent(&hObjParent);
		XuiSendMessage( hObjParent , &xuiMsg );
	}

	bHandled = true;
	return S_OK;
}

HRESULT CFilesList::OnDoBack( BOOL& bHandled )
{
	DebugMsg("DoBack : %s",FL_CurrentDir.c_str());
	FL_CurrentDir = FL_CurrentDir.substr(0,FL_CurrentDir.rfind("\\"));
	DebugMsg("New Dir : %s",FL_CurrentDir.c_str());

	BOOL Temp = FALSE;
	CurSel = 0;
	SetCurSel(0);
	SetTopItem(0);
	OnListRefresh(Temp);

	XUIMessage xuiMsg;
	XuiMessage(&xuiMsg, XM_FILES_DIRCHANGE);
	HXUIOBJ hObjParent;
	this->GetParent(&hObjParent);
	XuiSendMessage( hObjParent , &xuiMsg );

	return S_OK;
}
